<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class ZamanEposPreload {

    private $CI;

    public function __construct() {
        $this->CI = & get_instance();
    }

    function EposConfiguation() {
        foreach ($this->CI->Appconfig->get_all()->result() as $app_config) {
            $this->CI->config->set_item($app_config->key, $app_config->value);
        }
        if ($this->CI->config->item('locale_lang')) {
            $this->CI->config->set_item('language', $this->CI->config->item('locale_lang'));
            $language = $this->CI->config->item('locale_lang');
            if (!file_exists('./application/language/' . $language)) {
                $language = 'english';
            }
            $map = directory_map('./application/language/' . $language);
            foreach ($map as $file) {
                if (!is_array($file) && substr(strrchr($file, '.'), 1) == "php") {
                    $this->CI->lang->load(str_replace('_lang.php', '', $file), $language);
                }
            }
        }
        if ($this->CI->config->item('locale_timezone')) {
            date_default_timezone_set($this->CI->config->item('locale_timezone'));
        } else {
            date_default_timezone_set('Europe/London');
        }
    }

}
