<?php

class MY_Controller extends MX_Controller {

    public $cookies;
    public $hasUpdate;

    function __construct() {
        parent::__construct();
        $this->cookies = $this->My_Model->checkEposCookie();
        $this->hasUpdate = $this->My_Model->hasEposUpdate();
        //$this->load->driver('cache', array('adapter' => 'apc', 'backup' => 'file', 'key_prefix' => 'epos_'));
    }

    public function uploadimage($config, $image) {
        $this->load->helper('directory');
        $this->load->library('upload', $config);
        $this->upload->do_upload($image);
        return strlen($this->upload->display_errors()) == 0 || !strcmp($this->upload->display_errors(), '<p>' . $this->lang->line('upload_no_file_selected') . '</p>');
    }

    public function preparePostedData() {
        $items = array();
        foreach ($this->input->post() as $key => $value) {
            $items[] = $key;
        }
        return elements($items, $this->input->post());
    }

    public function send_email($data = null) {
        if ($data != null || !empty($data)) {
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $config['send_multipart'] = FALSE;
            $config['wordwrap'] = TRUE;
            $this->email->initialize($config);
            $this->email->from($data['from'], $data['from_title']);
            $this->email->to($data['to']);
            $this->email->subject($data['subject']);
            $this->email->message($data['message']);
            $this->email->reply_to($data['from'], $data['from_title']);
            if ($_SERVER['SERVER_NAME'] != 'localhost') {
                return $this->email->send() ? TRUE : FALSE;
            } else {
                return TRUE;
            }
        }
    }

}
